<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('libele', 'statut', 'add_by', 'id_intent');
    protected $visible = array('libele', 'statut', 'add_by', 'id_intent');

    public function intent()
    {
        return $this->belongsTo('App\Models\Intent', 'id_intent');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\User', 'add_by');
    }

}